//@author: colorsound
//@help: 
//@tags:3D vision
//@credits:
//woei for Anaglyph http://vvvv.org/forum/anaglyph-patch
//mediadog&microdee for interlaced http://vvvv.org/forum/passive-%28interlaced%29-3d-shader
// --------------------------------------------------------------------------------------------------
// PARAMETERS:
// --------------------------------------------------------------------------------------------------


//transforms
float4x4 tW: WORLD; //the models world matrix
float4x4 tV: VIEW; //view matrix as set via Renderer 
float4x4 tP: PROJECTION; //projection matrix as set via Renderer 
float4x4 tWVP: WORLDVIEWPROJECTION;

#include "SBS_HVs.fxh"
//Blend Function 
#define blend(op,c0,c1) float4(lerp((c0*c0.a+c1*c1.a*(1-c0.a))/saturate(c0.a+c1.a*(1-c0.a)),(op),c0.a*c1.a).rgb,saturate(c0.a+c1.a*(1-c0.a)))

//float Blend <bool visible=false; > = 0.5f ;
Texture2D Tex <string uiname="Left";>;
Texture2D Tex2<string uiname="Right";>;

float Alpha <float uimin=0.0; float uimax=1.0;> = 1;
float AlphaL <float uimin=0.0; float uimax=1.0;> = 1;
float AlphaR <float uimin=0.0; float uimax=1.0;> = 1;
bool EnableL ;
bool EnableR ;
int ScreenY  = 0;

float4 cAmb <bool color=true;String uiname="Color";> = { 1.0f,1.0f,1.0f,1.0f };


SamplerState g_samLinear
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};

//texture transform
float4x4 tTex <bool uvspace=true; string uiname="Texture Transform";>;

struct vs2ps
{
   float4 Pos : SV_POSITION;
   float4 TexCd : TEXCOORD0;
   float4 TexCdL : TEXCOORD1;
   float4 TexCdR : TEXCOORD2;
};
// -------------------------------------------------------------------------
// VERTEXSHADERS
// -------------------------------------------------------------------------

vs2ps VS(
   float4 Pos : POSITION,
   float4 TexCd : TEXCOORD0)
{
   //inititalize all fields of output struct with 0
   vs2ps Out = (vs2ps)0;

   //transform position
   Out.Pos = mul(Pos, tWVP);
   //transform texturecoordinates
   Out.TexCd = mul(TexCd,tTex);
   

   return Out;
}

vs2ps SBSHV_VS(
   float4 Pos : POSITION,
   float4 TexCd : TEXCOORD0)
{
   //inititalize all fields of output struct with 0
   vs2ps Out = (vs2ps)0;

	TransHV HVLR;
	float4x4 L = HV.IFunction(HVLR).L;
	float4x4 R = HV.IFunction(HVLR).R;
   //transform position
   Out.Pos = mul(Pos, tWVP);

   //transform texturecoordinates
   Out.TexCd = mul(TexCd,tTex);
   Out.TexCdL = mul(TexCd, mul(tTex,L));
   Out.TexCdR = mul(TexCd,mul(tTex,R));

   return Out;
}


// -------------------------------------------------------------------------
// PIXELSHADERS:
// -------------------------------------------------------------------------

float4 SBS_PS(vs2ps In): SV_Target
{
   //texture lookup to access the pixels of the texture
   float4 col = Tex.SampleLevel(g_samLinear, In.TexCdL,0);
   float4 col2 = Tex2.SampleLevel(g_samLinear, In.TexCdR,0);
   col.a *= AlphaL;
   col2.a *= AlphaR;
	
   float4 colFinal =col+col2;
   colFinal *=Alpha;
	
   return colFinal;
}

float4 SBSSimu_PS(vs2ps In): SV_Target
{
   //texture lookup to access the pixels of the texture
   float4 col = Tex.SampleLevel(g_samLinear, In.TexCd,0)*cAmb;
   float4 col2 = Tex2.SampleLevel(g_samLinear, In.TexCd,0)*cAmb;
   col.a *= AlphaL;
   col2.a *= AlphaR;
	

   float4 Finalcolor=blend(col+col2*saturate(1-col),col,col2);
 
   Finalcolor *=Alpha;
	
   return Finalcolor;
}

float4 Interlace_PS(vs2ps In): SV_Target
{
	int y = In.TexCd.y * ScreenY;
	float4 col;
 	
	if ( (y % 2) == 0 )
	{
		col = Tex.SampleLevel(g_samLinear, In.TexCd,0)*cAmb*EnableL;
		col.a *= AlphaL;
	}  
	else
	{
		col = Tex2.SampleLevel(g_samLinear, In.TexCd,0)*cAmb*EnableR;
        col.a *= AlphaR;
	}
	col.a *= Alpha;
    return col;
}



float4 Anaglyph_PS(vs2ps In): SV_Target
{
   //texture lookup to access the pixels of the texture
   float4 col = Tex.SampleLevel(g_samLinear, In.TexCd,0) * cAmb;
   float4 col2 = Tex2.SampleLevel(g_samLinear, In.TexCd,0) * cAmb;
   col.a *= AlphaL;
   col2.a *= AlphaR;
	
   col.a=max(col.a,col2.a);

   col.r = col.r;
   col.g = col2.g;
   col.b = col2.b;
	
   col.a *= Alpha;
	
   return col;
}

// -------------------------------------------------------------------------
// TECHNIQUES:
// -------------------------------------------------------------------------



technique11 SBSHV
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_5_0, SBSHV_VS() ) );
		SetPixelShader( CompileShader( ps_5_0, SBS_PS() ) );
	}
}

technique11 SBSHV_Simulation
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_5_0, SBSHV_VS() ) );
		SetPixelShader( CompileShader( ps_5_0, SBSSimu_PS() ) );
	}
}

technique11 T3DInterlace
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_5_0, VS() ) );
		SetPixelShader( CompileShader( ps_5_0, Interlace_PS() ) );
	}
}

technique11 Anaglyph
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_5_0, VS() ) );
		SetPixelShader( CompileShader( ps_5_0, Anaglyph_PS() ) );
	}
}